/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.superplan;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.store.InPlanPtnStoreActivity;
import cz.insophy.inplan.store.InPlanStoreActivity;
import cz.insophy.inplan.store.StoreActivityFactory;
import cz.insophy.inplan.store.StoreActivityOwner;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.ProductionTreeNode;
import cz.insophy.inplan.superplan.ProductionTreeVisitor;
import cz.insophy.inplan.superplan.Superplan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class GeneralizedActionRequest
extends GeneralizedRequest
implements StoreActivityOwner {
    private final List<ActionActivity> activities;
    private List<InPlanPtnStoreActivity> storeActs;
    @Nonnull
    private Action action;
    private boolean actionLocked;
    private double outOfPlanMat;
    private double completedMat;
    private long latestPossibleStart;
    private Plan plan;
    private boolean blocked;

    public GeneralizedActionRequest(@Nonnull Action action, double requestedQty) {
        this(action, requestedQty, -9223372036854775708L, -9223372036854775708L);
    }

    public GeneralizedActionRequest(@Nonnull Action action, double requestedQty, long releaseDate, long dueDate) {
        this(action, requestedQty, releaseDate, dueDate, -9223372036854775708L);
    }

    public GeneralizedActionRequest(@Nonnull Action action, double requestedQty, long releaseDate, long dueDate, long latestPossibleStart) {
        super(GeneralizedActionRequest.computeRealRequestedQty(action, requestedQty), releaseDate, dueDate);
        this.latestPossibleStart = latestPossibleStart;
        this.action = action;
        this.actionLocked = false;
        this.activities = new ArrayList<ActionActivity>();
        this.storeActs = Lists.newArrayList();
        this.updateSummaryData();
    }

    private static double computeRealRequestedQty(Action action, double requestedQty) {
        Preconditions.checkNotNull(action, "GAR's action cannot be null.");
        return action.computeRequestedQty(requestedQty);
    }

    @Override
    @Nonnull
    public String getId() {
        throw new UnsupportedOperationException("GARs do not have unique ids (yet).");
    }

    public List<ActionActivity> getActivities() {
        return this.activities;
    }

    @Override
    public void unsafeSetParent(ProductionTreeNode parent) {
        super.unsafeSetParent(parent);
        if (parent == null) {
            return;
        }
        GeneralizedOrderRequest gor = (GeneralizedOrderRequest)parent;
        if (this.getPlan() == null) {
            this.setPlan(gor.getPlan());
        } else if (gor.getPlan() != null && this.getPlan() != gor.getPlan()) {
            throw new IllegalArgumentException("GAR cannot be added to a GOR with different plan.");
        }
    }

    @Override
    public void unsafeAddChild(ProductionTreeNode child) {
        if (!(child instanceof ActionActivity)) {
            throw new UnsupportedOperationException("Invalid type of PTN passed: " + child.getClass());
        }
        this.unsafeAddActivity((ActionActivity)child);
    }

    public void unsafeAddActivity(ActionActivity aa) {
        this.activities.add(aa);
        aa.unsafeSetParent(this);
    }

    @Override
    public boolean unsafeRemoveChild(ProductionTreeNode child) {
        if (child instanceof ActionActivity) {
            return this.unsafeRemoveActivity((ActionActivity)child);
        }
        throw new UnsupportedOperationException("Invalid type of PTN passed: " + child.getClass());
    }

    public boolean unsafeRemoveActivity(ActionActivity aa) {
        boolean res = this.activities.remove(aa);
        if (res) {
            aa.unsafeSetParent(null);
            this.updateStoreActs();
        }
        return res;
    }

    @Nonnull
    public Action getAction() {
        return this.action;
    }

    public void setAction(@Nonnull Action action) {
        Preconditions.checkNotNull(action, "Action cannot be null.");
        boolean isAlt = false;
        for (Action alt : this.action.getLocalAlts()) {
            if (alt != action) continue;
            isAlt = true;
        }
        Preconditions.checkArgument(isAlt, "%s is not LA of %s", (Object)action, (Object)this.action);
        Preconditions.checkState(!this.actionLocked, "The action (local alternative) is locked.");
        Preconditions.checkState(this.activities.isEmpty(), "Cannot change action of GAR when there are activities.");
        this.action = action;
        this.updateStoreActs();
    }

    public boolean canChangeAction() {
        return !this.actionLocked && this.activities.isEmpty();
    }

    public boolean isActionLocked() {
        return this.actionLocked;
    }

    public void setActionLocked(boolean actionLocked) {
        this.actionLocked = actionLocked;
    }

    private double calculateInPlanQty() {
        double res = 0.0;
        for (ActionActivity aa : this.activities) {
            res += aa.getQty();
        }
        return res;
    }

    @Override
    public void updateSummaryData() {
        this.unsafeSetInPlanQty(this.calculateInPlanQty());
        this.unsafeSetTotalPlannedQty(this.getPlannedQty());
        this.unsafeSetTotalRequestedQty(this.getRequestedQty());
        this.unsafeSetTotalCompletedQty(this.getCompletedQty());
    }

    @Override
    public void updateStartEnd() {
        long endDate = Long.MIN_VALUE;
        long startDate = Long.MAX_VALUE;
        long plannedDuration = 0L;
        if (!this.activities.isEmpty()) {
            for (ActionActivity aa : this.activities) {
                if (aa.getEnd() > endDate) {
                    endDate = aa.getEnd();
                }
                if (aa.getStart() < startDate) {
                    startDate = aa.getStart();
                }
                plannedDuration += aa.getDuration();
            }
        }
        this.unsafeSetStartDate(startDate);
        this.unsafeSetEndDate(endDate);
        this.unsafeSetPlannedDuration(plannedDuration);
    }

    public String toString() {
        return String.format("GAR(%s, %f, %f)", this.action.getName(), this.getRequestedQty(), this.getPlannedQty());
    }

    @Override
    public void accept(ProductionTreeVisitor visitor, boolean childrenFirst) {
        if (!childrenFirst) {
            visitor.visit(this);
        }
        for (ActionActivity aa : this.activities) {
            aa.accept(visitor, childrenFirst);
        }
        if (childrenFirst) {
            visitor.visit(this);
        }
    }

    @Override
    public Superplan getSuperplan() {
        return ProductionTreeAlgorithms.getSuperplan(this);
    }

    public void addAa(ActionActivity aa) {
        ProductionTreeAlgorithms.addAa(aa, this);
    }

    public void removeAa(ActionActivity aa) {
        ProductionTreeAlgorithms.removeAa(aa, this);
    }

    public List<? extends ProductionTreeNode> removeRelatedActivities() {
        return ProductionTreeAlgorithms.removeRelatedActivities(this);
    }

    public void notifyAaChanged() {
        this.updateStoreActs();
    }

    private void updateStoreActs() {
        for (InPlanStoreActivity inPlanStoreActivity : this.storeActs) {
            inPlanStoreActivity.setPlan(null);
        }
        this.storeActs.clear();
        if (this.plan == null) {
            return;
        }
        this.storeActs = StoreActivityFactory.createStoreActivities(this);
        for (InPlanStoreActivity inPlanStoreActivity : this.storeActs) {
            inPlanStoreActivity.setPlan(this.plan);
        }
    }

    public List<InPlanPtnStoreActivity> getStoreActivities() {
        return Collections.unmodifiableList(this.storeActs);
    }

    @Override
    public void setPlan(Plan plan) {
        this.plan = plan;
        this.updateStoreActs();
        if (this.plan != null) {
            this.setProperties(null, this.plan.getShopConf().getPropertyDefinitionsInfoFor(GeneralizedActionRequest.class));
        }
    }

    public Plan getPlan() {
        return this.plan;
    }

    @Override
    protected void unsafeSetEndDate(long endDate) {
        super.unsafeSetEndDate(endDate);
        this.updateStoreActs();
    }

    @Override
    public void unsafeSetDueDate(long dueDate) {
        super.unsafeSetDueDate(dueDate);
        this.updateStoreActs();
    }

    @Override
    public void unsafeSetReleaseDate(long releaseDate) {
        super.unsafeSetReleaseDate(releaseDate);
        this.updateStoreActs();
    }

    public void setReleaseDate(long releaseDate) {
        this.unsafeSetReleaseDate(releaseDate);
    }

    public void setDueDate(long dueDate) {
        this.unsafeSetDueDate(dueDate);
    }

    @Override
    public void unsafeSetOutOfPlanQty(double outOfPlanQty) {
        super.unsafeSetOutOfPlanQty(outOfPlanQty);
        this.updateStoreActs();
    }

    public void unsafeSetOutOfPlanMat(double outOfPlanMat) {
        this.outOfPlanMat = outOfPlanMat;
        this.updateStoreActs();
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public double getOutOfPlanMat() {
        return this.outOfPlanMat;
    }

    public void setOutOfPlanMat(double outOfPlanMat) {
        this.unsafeSetOutOfPlanMat(outOfPlanMat);
        if (this.getParent() != null) {
            this.getParent().childChanged(this);
        }
    }

    public double getCompletedMat() {
        return this.completedMat;
    }

    public void setCompletedMat(double completedMat) {
        this.completedMat = completedMat;
    }

    public long getLatestPossibleStart() {
        return this.latestPossibleStart;
    }

    public void setLatestPossibleStart(long latestPossibleStart) {
        this.latestPossibleStart = latestPossibleStart;
        if (this.getParent() != null) {
            this.getParent().childChanged(this);
        }
    }
}

